/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.inconn;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public class InboundConfigData
implements Persistable {
    private static final String TRACE_MASKT = "XRCSICDT";
    private static final String TRACE_MASKF = "XRCSICDF";
    private static final String TRACE_MASKD = "XRCSICDD";
    private boolean allowCallAnswer = false;
    private boolean allowUnattendedService = false;
    private String modemPhoneNumber = "";
    private int unattendedDurationType = 0;
    private int unattendedAutoDays = 0;
    private Date unattendedTempStart = null;
    private Date unattendedTempEnd = null;
    public static final int DURATION_TYPE_CONTINUOUS = 0;
    public static final int DURATION_TYPE_AUTOMATIC = 1;
    public static final int DURATION_TYPE_TEMPORARY = 2;

    public InboundConfigData() {
        Trace.trace(TRACE_MASKT, "<> InboundConfigData()");
    }

    protected InboundConfigData(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        this.allowCallAnswer = persistent.allowCallAnswer;
        this.allowUnattendedService = persistent.allowUnattendedService;
        this.modemPhoneNumber = persistent.version < 2 ? "" : persistent.modemPhoneNumber;
        this.unattendedDurationType = persistent.unattendedDurationType;
        this.unattendedAutoDays = persistent.unattendedAutoDays;
        this.unattendedTempStart = persistent.unattendedTempStart;
        this.unattendedTempEnd = persistent.unattendedTempEnd;
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        persistent.version = 2;
        persistent.allowCallAnswer = this.allowCallAnswer;
        persistent.allowUnattendedService = this.allowUnattendedService;
        persistent.modemPhoneNumber = this.modemPhoneNumber;
        persistent.unattendedDurationType = this.unattendedDurationType;
        persistent.unattendedAutoDays = this.unattendedAutoDays;
        persistent.unattendedTempStart = this.unattendedTempStart;
        persistent.unattendedTempEnd = this.unattendedTempEnd;
        return persistent;
    }

    public boolean isUpgradeData() {
        return true;
    }

    public boolean isAllowCallAnswer() {
        return this.allowCallAnswer;
    }

    public void setAllowCallAnswer(boolean value) {
        this.allowCallAnswer = value;
    }

    public boolean isAllowUnattendedService() {
        return this.allowUnattendedService;
    }

    public void setAllowUnattendedService(boolean value) {
        this.allowUnattendedService = value;
    }

    public String getModemPhoneNumber() {
        return this.modemPhoneNumber;
    }

    public void setModemPhoneNumber(String number) {
        this.modemPhoneNumber = number;
    }

    public int getUnattendedDurationType() {
        return this.unattendedDurationType;
    }

    public void setUnattendedDurationType(int type) {
        if (!this.isDurationTypeValid(type)) {
            throw new IllegalArgumentException("Invalid duration type");
        }
        this.unattendedDurationType = type;
    }

    private boolean isDurationTypeValid(int type) {
        switch (type) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public int getUnattendedAutoDays() {
        return this.unattendedAutoDays;
    }

    public void setUnattendedAutoDays(int days) {
        this.unattendedAutoDays = days;
    }

    public Date getUnattendedTempStart() {
        return this.unattendedTempStart;
    }

    public void setUnattendedTempStart(Date date) {
        this.unattendedTempStart = date;
    }

    public Date getUnattendedTempEnd() {
        return this.unattendedTempEnd;
    }

    public void setUnattendedTempEnd(Date date) {
        this.unattendedTempEnd = date;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[InboundConfigData:\n");
        sb.append("allowCallAnswer=" + this.allowCallAnswer + "\n");
        sb.append("allowUnattendedService=" + this.allowUnattendedService + "\n");
        sb.append("modemPhoneNumber=" + this.modemPhoneNumber + "\n");
        sb.append("unattendedDurationType=" + this.unattendedDurationType + "\n");
        sb.append("unattendedAutoDays=" + this.unattendedAutoDays + "\n");
        if (this.unattendedTempStart != null) {
            sb.append("unattendedTempStart=" + this.unattendedTempStart + "\n");
        } else {
            sb.append("unattendedTempStart=null\n");
        }
        if (this.unattendedTempEnd != null) {
            sb.append("unattendedTempEnd=" + this.unattendedTempEnd);
        } else {
            sb.append("unattendedTempEnd=null");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = 7841799017580831635L;
        int version;
        boolean allowCallAnswer;
        boolean allowUnattendedService;
        String modemPhoneNumber;
        int unattendedDurationType;
        int unattendedAutoDays;
        Date unattendedTempStart;
        Date unattendedTempEnd;

        private Persistent() {
        }
    }
}

